// Generated by CoffeeScript 1.10.0
(function() {
  var HUD, Tween, root;

  HUD = {
    tween: null,
    hudUI: null,
    _displayElement: null,
    findMode: null,
    init: function() {
      this.hudUI = new UIComponent("pages/hud.html", "vimiumHUDFrame", (function(_this) {
        return function(arg) {
          var data, name;
          data = arg.data;
          return typeof _this[name = data.name] === "function" ? _this[name](data) : void 0;
        };
      })(this));
      return this.tween = new Tween("iframe.vimiumHUDFrame.vimiumUIComponentVisible", this.hudUI.shadowDOM);
    },
    showForDuration: function(text, duration) {
      this.show(text);
      return this._showForDurationTimerId = setTimeout(((function(_this) {
        return function() {
          return _this.hide();
        };
      })(this)), duration);
    },
    show: function(text) {
      if (!this.enabled()) {
        return;
      }
      clearTimeout(this._showForDurationTimerId);
      this.hudUI.show({
        name: "show",
        text: text
      });
      return this.tween.fade(1.0, 150);
    },
    showFindMode: function(findMode) {
      this.findMode = findMode != null ? findMode : null;
      if (!this.enabled()) {
        return;
      }
      this.hudUI.show({
        name: "showFindMode",
        text: ""
      });
      return this.tween.fade(1.0, 150);
    },
    search: function(data) {
      var matchCount, showMatchText;
      this.findMode.findInPlace(data.query);
      matchCount = FindMode.query.parsedQuery.length > 0 ? FindMode.query.matchCount : 0;
      showMatchText = FindMode.query.rawQuery.length > 0;
      return this.hudUI.postMessage({
        name: "updateMatchesCount",
        matchCount: matchCount,
        showMatchText: showMatchText
      });
    },
    hide: function(immediate, updateIndicator) {
      if (immediate == null) {
        immediate = false;
      }
      if (updateIndicator == null) {
        updateIndicator = true;
      }
      if (this.tween == null) {
        return;
      }
      clearTimeout(this._showForDurationTimerId);
      this.tween.stop();
      if (immediate) {
        if (!updateIndicator) {
          this.hudUI.hide();
          this.hudUI.postMessage({
            name: "hide"
          });
        }
        if (updateIndicator) {
          return Mode.setIndicator();
        }
      } else {
        return this.tween.fade(0, 150, (function(_this) {
          return function() {
            return _this.hide(true, updateIndicator);
          };
        })(this));
      }
    },
    hideFindMode: function(data) {
      var event, focusNode, postExit, ref;
      this.findMode.checkReturnToViewPort();
      window.focus();
      focusNode = DomUtils.getSelectionFocusElement();
      if ((ref = document.activeElement) != null) {
        ref.blur();
      }
      if (focusNode != null) {
        focusNode.focus();
      }
      event = data.event;
      if (event.keyCode === keyCodes.enter) {
        handleEnterForFindMode();
        if (FindMode.query.hasResults) {
          postExit = function() {
            return new PostFindMode;
          };
        }
      } else if (KeyboardUtils.isEscape(event)) {
        postExit = handleEscapeForFindMode;
      }
      this.findMode.exit();
      return typeof postExit === "function" ? postExit() : void 0;
    },
    isReady: (function() {
      var ready;
      ready = false;
      DomUtils.documentReady(function() {
        return ready = true;
      });
      return function() {
        return ready && document.body !== null;
      };
    })(),
    enabled: function() {
      return !Settings.get("hideHud");
    }
  };

  Tween = (function() {
    Tween.prototype.opacity = 0;

    Tween.prototype.intervalId = -1;

    Tween.prototype.styleElement = null;

    function Tween(cssSelector, insertionPoint) {
      this.cssSelector = cssSelector;
      if (insertionPoint == null) {
        insertionPoint = document.documentElement;
      }
      this.styleElement = DomUtils.createElement("style");
      if (!this.styleElement.style) {
        Tween.prototype.fade = Tween.prototype.stop = Tween.prototype.updateStyle = function() {};
        return;
      }
      this.styleElement.type = "text/css";
      this.styleElement.innerHTML = "";
      insertionPoint.appendChild(this.styleElement);
    }

    Tween.prototype.fade = function(toAlpha, duration, onComplete) {
      var alphaStep, fromAlpha, performStep, startTime;
      clearInterval(this.intervalId);
      startTime = (new Date()).getTime();
      fromAlpha = this.opacity;
      alphaStep = toAlpha - fromAlpha;
      performStep = (function(_this) {
        return function() {
          var elapsed, value;
          elapsed = (new Date()).getTime() - startTime;
          if (elapsed >= duration) {
            clearInterval(_this.intervalId);
            _this.updateStyle(toAlpha);
            return typeof onComplete === "function" ? onComplete() : void 0;
          } else {
            value = (elapsed / duration) * alphaStep + fromAlpha;
            return _this.updateStyle(value);
          }
        };
      })(this);
      this.updateStyle(this.opacity);
      return this.intervalId = setInterval(performStep, 50);
    };

    Tween.prototype.stop = function() {
      return clearInterval(this.intervalId);
    };

    Tween.prototype.updateStyle = function(opacity) {
      this.opacity = opacity;
      return this.styleElement.innerHTML = this.cssSelector + " {\n  opacity: " + this.opacity + ";\n}";
    };

    return Tween;

  })();

  root = typeof exports !== "undefined" && exports !== null ? exports : window;

  root.HUD = HUD;

}).call(this);
